<?php
namespace Modules\Inquiry\Repositories;

use Modules\Inquiry\Entities\Inquiry;
use Modules\Inquiry\Repositories\InquiryInterface;
use Modules\Inquiry\Repositories\InquiryRepository;


class InquiryRepository implements InquiryInterface
{

    public function findAll($limit = null, $filter = [], $sort = ['by' => 'sort_order', 'sort' => 'ASC'], $status = [0, 1])
    {


        $result = Inquiry::when(array_keys($filter, true), function ($query) use ($filter) {

            if (isset($filter['title'])) {
                $query->where('title', 'like', '%' . $filter['title'] . '%');

            }
//            if (isset($filter['start_date'])) {
//                $query->where('created_at','>=', $filter['start_date']);
//            }
//
//            if (isset($filter['end_date'])) {
//                $query->where('created_at','<=', $filter['end_date']);
//            }
            return $query;
        })
            ->whereIn('status', $status)
            ->orderBy($sort['by'], $sort['sort'])
            ->paginate($limit ? $limit : env('DEF_PAGE_LIMIT',9999999999));
        return $result;
    }

    public function find($id){
        return Inquiry::find($id);
    }

   public function getList(){
       $result = Inquiry::pluck('type_name', 'id');

       return $result;
   }

    public function save($data){
        return Inquiry::create($data);
    }

    public function update($id,$data){
        $result = Inquiry::find($id);
        return $result->update($data);
    }

    public function delete($id){
        return Inquiry::destroy($id);
    }

    public function upload($file){
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);

        $file->move(public_path() . Inquiry::FILE_PATH, $fileName);
        $fileName=Inquiry::FILE_PATH.$fileName;
        return $fileName;
    }

    public function getActiveInquiry()
    {
       return Inquiry::where('status',1)->get();
    }

}
