<?php
namespace Modules\OurTeam\Entities;

use App\Models\User;
use Illuminate\Database\Eloquent\Model;
use Modules\Package\Entities\Package;

class OurTeam extends Model
{
    const FILE_PATH     = '/uploads/ourteam/';
    protected $table    = 'our_teams';
    protected $fillable = [

        'title',
        'image',
        'post',
        'short_description',
        'description',

        'created_by',
        'updated_by',
        'sort_order',

        'status',

    ];
    public function package()
    {
        return $this->belongsToMany(Package::class, 'package_guides', 'ourteam_id', 'package_id');
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }
}