@extends('layouts.backmaster')

@section('title', 'Sarathi Holidays')

@section('csssec')
@stop

@section('jssec')
@stop

@section('content_title')
    <table style="width:100%">
        <tr>
            <th class="headtext">
                Package
            </th>
            <th class="float-right">
                <a href="{{ route('package.index') }}" class="btn btn-outline-primary pull-right">
                    List</a>
            </th>
        </tr>
    </table>
@endsection

@section('seccontent')
    @if (session('status'))
        <div class="alert alert-success">
            {{ session('status') }}
        </div>
    @endif

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
            <div class="panel panel-default">
                <div class="panel-body">
                    @if (!isset($package->id))
                        <form method="post" action="{{ route('package.store') }}" enctype="multipart/form-data"
                            class="valid_form">
                            <input type="hidden" class="form-control" name="created_by" value="{{ Auth::user()->id }}">
                        @else
                            <form method="post" action="{{ route('package.update', $package) }}" method="post"
                                enctype="multipart/form-data" class="valid_form">
                                {{-- <input type="hidden" name="_method" value="put"> --}}
                                {{ method_field('PUT') }}

                                <input type="hidden" class="form-control" name="updated_by" value="{{ Auth::user()->id }}">
                                {{-- <input type="hidden" class="form-control" name="created_by" value="{{$package->created_by}}">
                        --}}
                    @endif
                    {{ csrf_field() }}

                    <div class="row">
                        <div class="col-md-8 col-xs-12">
                            <div class="form-group ">
                                <label for="title">Title:</label>
                                <input type="text" name="title" class="form-control"
                                    value="{{ old('title', $package->title) }}" required>
                                @if ($errors->has('title'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('title') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="currency_type">Currency:</label>
                                <input type="text" name="currency_type" class="form-control"
                                    value="{{ old('currency_type', $package->currency_type) }}" required>
                                @if ($errors->has('currency_type'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('currency_type') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        {{-- <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="fact">Fact:</label>
                                    <input type="text" name="fact" class="form-control"
                                        value="{{old('fact',$package->fact)}}" required>
                                    @if ($errors->has('fact'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('fact') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div> --}}


                    </div>
                    <div class="row">
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="duration">Duration:</label>
                                <input type="text" name="duration" class="form-control"
                                    value="{{ old('duration', $package->duration) }}" required>
                                @if ($errors->has('duration'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('duration') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="starting_point">Starting Point:</label>
                                <input type="text" name="starting_point" class="form-control"
                                    value="{{ old('starting_point', $package->starting_point) }}" required>
                                @if ($errors->has('starting_point'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('starting_point') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="ending_point">Ending Point:</label>
                                <input type="text" name="ending_point" class="form-control"
                                    value="{{ old('ending_point', $package->ending_point) }}" required>
                                @if ($errors->has('ending_point'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('ending_point') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>



                    </div>

                    <div class="row">

                        <div class="col-md-6 col-xs-12">
                            <div class="form-group">
                                <label>Image :</label>
                                <input type="file" class="form-control dropify" name="image" value=""
                                    data-default-file="{{ $package->image ? asset($package->image) : '' }}">
                                @if (isset($package->id))
                                    <img src="{{ asset($package->image) }}" height="100" width="150">
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group">
                                <label> Package Gallary :</label>
                                <input type="file" class="form-control" name="package_gallary[]" multiple value="">
                                @if ($package->packagegallery()->count() > 0)
                                    @foreach ($package->packagegallery as $item)
                                        <img src="{{ asset($item->image) }}" height="100" width="150">
                                    @endforeach

                                @endif
                            </div>
                        </div>







                        {{-- <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="sort_order"> Sort Order:</label>
                                    <input type="number" name="sort_order" class="form-control"
                                        value="{{old('sort_order',$package->sort_order)}}" required>
                                    @if ($errors->has('sort_order'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('sort_order') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div> --}}
                        {{-- <div class="col-md-6 col-xs-12">
                                <div class="form-group ">
                                    <label for="title">Parent:</label>
                                    <select name="parent" class="form-control myselect">
                                        <option value=""></option>
                                        @foreach ($parentPackage as $item)
                                        <option value="{{ $item->id }}" {{$package->parent==$item->id?'selected':''}}>{{ $item->title }}</option>
                                        @endforeach
                                    </select>
                                    @if ($errors->has('parent'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('parent') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div> --}}
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="package_id">Package Management :</label>

                                <select name="package_mgmt_id[]" class="form-control myselect" multiple>
                                    <option value=""></option>
                                    @foreach ($packagemanagement as $item)
                                        <option value="{{ $item->id }}"
                                            {{ in_array($item->id, $package->packageMgmt->pluck('id')->toArray()) ? 'selected' : '' }}>
                                            {{ $item->title }}</option>
                                    @endforeach
                                </select>

                                @if ($errors->has('package_mgmt_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('package_mgmt_id') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="package_id">Package Guide:</label>

                                <select name="ourteam_id[]" class="form-control myselect" multiple>
                                    <option value=""></option>
                                    @foreach ($ourteam as $item)
                                        <option value="{{ $item->id }}"
                                            {{ in_array($item->id, $package->packageGuide->pluck('id')->toArray()) ? 'selected' : '' }}>
                                            {{ $item->title }}</option>
                                    @endforeach
                                </select>

                                @if ($errors->has('ourteam_id'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('ourteam_id') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="title">Meta Title:</label>
                                <input type="text" name="meta_title" class="form-control"
                                    value="{{ old('meta_title', $package->meta_title) }}" required>
                                @if ($errors->has('meta_title'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('meta_title') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>



                    </div>
                    <div class="row">
                        <div class="col-md-12 col-xs-12">
                            <div class="form-group ">
                                <label for="description">Description:</label>
                                <textarea name="description" id="" class="my-editor" cols="30" rows="10">{{ old('description', $package->description) }}</textarea>
                                {{-- <input type="text" name="link" class="form-control"
                                        value="{{old('link',$package->link)}}" required> --}}
                                @if ($errors->has('description'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('description') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="row">



                        <div class="col-md-12 col-xs-12">
                            <div class="form-group ">
                                <label for="itinerary">Itinerary:</label>
                                <textarea name="itinerary" id="" class="my-editor" cols="30" rows="10">{{ old('itinerary', $package->itinerary) }}</textarea>

                                {{-- <input type="text" name="itinerary" class="form-control"
                                        value="{{old('itinerary',$package->itinerary)}}" required> --}}
                                @if ($errors->has('itinerary'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('itinerary') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-12 col-xs-12">
                            <div class="form-group ">
                                <label for="includes">Includes/Exclude:</label>
                                <textarea name="includes" id="" class="my-editor" cols="30" rows="10">{{ old('includes', $package->includes) }}</textarea>
                                {{--
                                    <input type="text" name="includes" class="form-control"
                                        value="{{old('includes',$package->includes)}}" required> --}}
                                @if ($errors->has('includes'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('includes') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-12 col-xs-12">
                            <div class="form-group ">
                                <label for="fact">Fact:</label>
                                <textarea name="fact" id="" class="my-editor" cols="30" rows="10">{{ old('fact', $package->fact) }}</textarea>

                                {{-- <input type="text" name="fact" class="form-control"
                                        value="{{old('fact',$package->fact)}}" required> --}}
                                @if ($errors->has('fact'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('fact') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>



                    </div>
                    <div class="row">
                        <div class="col-md-12 col-xs-12">
                            <div class="form-group ">
                                <label for="map">Map:</label>
                                <input type="text" name="map" class="form-control"
                                    value="{{ old('map', $package->map) }}" required>
                                @if ($errors->has('map'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('map') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12 col-xs-12">
                            <div class="form-group ">
                                <label for="testimonial">Testimonial:</label>
                                <textarea name="testimonial" id="" class="my-editor" cols="30" rows="10">{{ old('testimonial', $package->testimonial) }}</textarea>
                                {{-- <input type="text" name="link" class="form-control"
                                        value="{{old('link',$package->link)}}" required> --}}
                                @if ($errors->has('testimonial'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('testimonial') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="meta_description"> Meta Description:</label> <br>
                                <textarea name="meta_description" id="">{{ old('meta_description', $package->meta_description) }}</textarea>
                                {{-- <input type="text" name="link" class="form-control"
                                        value="{{old('link',$package->link)}}" required> --}}
                                @if ($errors->has('meta_description'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('meta_description') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="short_description"> Short Description:</label> <br>
                                <textarea name="short_description" id="">{{ old('short_description', $package->short_description) }}</textarea>
                                {{-- <input type="text" name="link" class="form-control"
                                    value="{{old('link',$package->link)}}" required> --}}
                                @if ($errors->has('short_description'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('short_description') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group ">
                                <label for="sort_order"> Sort Order:</label>
                                <input type="number" name="sort_order" class="form-control"
                                    value="{{ old('sort_order', $package->sort_order) }}" required>
                                @if ($errors->has('sort_order'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('sort_order') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>

                    </div>


                    <div class="row">


                        <div class="col-md-6 col-xs-12">
                            <div class="form-group">
                                <label for="status">Status:</label><br>
                                <input type="radio" name="status" id="status" value="1" checked> Active<br>
                                <input type="radio" name="status" id="status" value="0"
                                    {{ $package->status == '0' ? 'checked' : '' }}> Inactive
                            </div>
                        </div>
                        <div class="col-md-4 col-xs-12">
                            <div class="form-group">
                                <label for="status">Is Featured:</label><br>
                                <input type="radio" name="is_featured" id="status" value="1" checked> Yes <br>
                                <input type="radio" name="is_featured" id="status" value="0"
                                    {{ $package->is_featured == '0' ? 'checked' : '' }}> No
                            </div>
                        </div>
                    </div>

                    <div class="row" style="padding:10px">
                        <div class="col-md-12">
                            <button class="btn btn-outline-success float-right">Save</button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@endsection
