@extends('layouts.backmaster')

@section('title', 'PressRelease')

@section('csssec')
@stop

@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
            Package
            {{-- <a href="{{route('package.inactiveindex')}}" class="btn btn-outline-info">Inactive Doctors</a>
            <a href="{{route('package.index')}}" class="btn btn-outline-info">Active Doctors</a> --}}
        </th>
        <th class="float-right">
            <a href="{{route('package.create')}}" class="btn btn-outline-primary float-right">Add New</a>
        </th>
    </tr>
</table>
@endsection
@section('seccontent')
<div class="row">
    <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
        <div class="panel panel-default">
            <div class="panel-body">
                @if(Session::has('success'))
                <div class="alert alert-success">
                    {{ Session::get('success') }}
                </div>
                @endif
                @if(Session::has('error'))
                <div class="alert alert-danger">
                    {{ Session::get('error') }}
                </div>
                @endif
                {{-- <form method="post" method="post" enctype="multipart/form-data" id="myForm"> --}}

                <table class="table table-bordered" id="datatable">
                    <thead>
                        <tr>
                            <th>S.N.</th>
                            <th>Title</th>
                            <th>Image</th>




                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($packages as $i=>$eachpackage)
                        <tr id="{{$eachpackage->id}}">
                            {{-- </form> --}}
                            <td>{{$i+1}}</td>
                            <td>{{$eachpackage->title}}</td>



                            <td>
                                @if ($eachpackage->image!=null)
                                <img src="{{asset($eachpackage->image)}}" height="100" width="150">
                                @else
                                <h3>No Image </h3>
                                @endif
                            </td>
                            {{-- <td>
                                <a href="{{asset($eachpackage->citizenship)}}" target="_blank">View File</a>
                            </td> --}}

                            <td>
                                @if($eachpackage->status==1)
                                <label class="badge badge-success">Active</label>
                                @else
                                <label class="badge badge-danger">Inactive</label>
                                @endif
                            </td>

                            <td>
                                <a href="{{route('package.edit', $eachpackage)}}" class="btn btn-outline-warning"
                                    data-toggle="tooltip" title="Edit Info"><i class="fa fa-edit"> </i></a>
                                <a href="{{route('package.show', $eachpackage->id)}}" data-toggle="tooltip"
                                    title="View Detail" class="btn btn-outline-success"><i class="fa fa-eye"></i></a>
                                <a href="{{route('packagegallery.index', ['package_id'=>$eachpackage->id])}}" data-toggle="tooltip"
                                    title="View Gallary" class="btn btn-outline-success"><i class="fa fa-eye"></i></a>
                                <form action="{{route('package.destroy', $eachpackage->id)}}" method="POST"
                                    onsubmit="return confirm('Are You Sure??')" style="display: inline;" id="delete-information-form">
                                    <input type="hidden" name="_method" value="delete">
                                    {{csrf_field()}}
                                    <button type="submit" class="btn btn-outline-danger" data-toggle="tooltip"
                                        title="Delete Information"><i class="fa fa-trash"></i></button>

                                </form>

                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
