<?php

namespace Modules\PackageGallery\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Illuminate\Support\Facades\Session;
use Illuminate\Contracts\Support\Renderable;
use Modules\Package\Repositories\PackageInterface;
use Modules\PackageGallery\Entities\PackageGallery;
use Modules\PackageGallery\Repositories\PackageGalleryInterface;

class PackageGalleryController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    protected $packageInterface;
    protected $packagegalleryInterface;

    public function __construct(
        PackageInterface $packageInterface,
        PackageGalleryInterface $packagegalleryInterface

        )
    {
        $this->packageInterface = $packageInterface;
        $this->packagegalleryInterface = $packagegalleryInterface;

    }
    public function index(Request $request)
    {
        $data['packagegallery']=PackageGallery::where('package_id',$request->package_id)->get();
        $data['package_id']=$request->package_id;
        return view('packagegallery::packagegallery.index',$data);
    }

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create(Request $request)
    {
        // dd($request);
        $data['packagegallery']=new PackageGallery();
        $data['package_id']=$request->package_id;
        $data['package']=$this->packageInterface->find($request->package_id);
        // dd($data);
        $data['is_edit']=0;


        // return view('imageinfo::imageinfo.create',$data);
        return view('packagegallery::packagegallery.create',$data);


        // return view('packagegallery::create');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(Request $request)
    {
        $data = $request->all();

        try{

            if($request->hasFile('image')){
                foreach($request->file('image') as $file)
            {
                $data['image'] = $this->packagegalleryInterface->upload($file);

                $result=$this->packagegalleryInterface->save($data);
                       # code...
            }

            }
            Session::flash('success', 'Information Added successfully.');


        }catch(\Throwable  $e){
            Session::flash('error', $e->getMessage());

        }
        return redirect(route('package.index'));
    }

    /**
     * Show the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function show($id)
    {
        return view('packagegallery::show');
    }

    /**
     * Show the form for editing the specified resource.
     * @param int $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data['is_edit']=1;
        $data['packagegallery'] = $this->packagegalleryInterface->find($id);
        $data['package'] = $this->packageInterface->find($id);

        return view('packagegallery::packagegallery.create',$data);
        // return view('imagegallery::edit');
    }
    /**
     * Update the specified resource in storage.
     * @param Request $request
     * @param int $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        // dd($id);
        $data = $request->all();

        try{


            // if($request->hasFile('image')){
            //     $data['image'] = $this->imageinfoInterface->upload($data['image']);
            // }
            if($request->hasFile('image')){

                $data['image'] = $this->packagegalleryInterface->upload($data['image']);
            }
            $this->packagegalleryInterface->update($id,$data);

            flash("Information Updated Successfully")->success();

        }catch(\Throwable $e){
            flash($e->getMessage())->error();

        }

        return redirect(route('package.index'));
    }

    /**
     * Remove the specified resource from storage.
     * @param int $id
     * @return Renderable
     */
    public function destroy($id)
    {
        try{
            $data=$this->packagegalleryInterface->find($id);
            $path=$data->image;
            $deleteStatus=$this->packagegalleryInterface->delete($id);
            if ($deleteStatus) {
                # code...
                $this->packagegalleryInterface->unlinkImage($path);
            }

            flash("Information Deleted Successfully")->success();
        }catch(\Throwable $e){
            flash($e->getMessage())->error();
        }
        return redirect()->back();
    }
}
