<?php

namespace Modules\PackageManagement\Entities;

use App\User;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;
use Modules\Package\Entities\Package;
use Illuminate\Database\Eloquent\Model;
use Modules\PackageManagement\Entities\PackageManagement;


class PackageManagement extends Model
{
    use HasSlug;

    const FILE_PATH='/uploads/packagemanagement/';
    protected $table='package_mgmts';
    protected $fillable = [
        'title',
        'meta_title',
        'meta_description',
        'slug',
        'image',
        'parent',
        'created_by',
        'updated_by',
        'sort_order',
        'highlighted_text',
        'show_home',
        'show_in_nav',
        'status',

    ];
    public function getSlugOptions() : SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('title')
            ->saveSlugsTo('slug');
    }

    public function createdBy(){
        return $this->belongsTo(User::class,'created_by');
    }
    public function updatedBy(){
        return $this->belongsTo(User::class,'updated_by');
    }
    public function parentPackage()
    {
        return $this->belongsTo(PackageManagement::class, 'parent');
    }
    public function childs()
    {
        return $this->hasMany(PackageManagement::class, 'parent');
    }
    public function package()
    {
        return $this->belongsToMany(Package::class,'package_mgmt_packages', 'package_mgmt_id','package_id');
    }
}
