<?php
namespace Modules\PackageManagement\Repositories;

use Modules\PackageManagement\Entities\PackageManagement;
use Modules\PackageManagement\Repositories\PackageManagementInterface;
use Modules\PackageManagement\Repositories\PackageManagementRepository;


class PackageManagementRepository implements PackageManagementInterface
{

    public function findAll($limit = null, $filter = [], $sort = ['by' => 'sort_order', 'sort' => 'ASC'], $status = [0, 1])
    {


        $result = PackageManagement::when(array_keys($filter, true), function ($query) use ($filter) {

            if (isset($filter['title'])) {
                $query->where('title', 'like', '%' . $filter['title'] . '%');

            }
//            if (isset($filter['start_date'])) {
//                $query->where('created_at','>=', $filter['start_date']);
//            }
//
//            if (isset($filter['end_date'])) {
//                $query->where('created_at','<=', $filter['end_date']);
//            }
            return $query;
        })
            ->whereIn('status', $status)
            ->orderBy($sort['by'], $sort['sort'])
            ->paginate($limit ? $limit : env('DEF_PAGE_LIMIT',9999999999));
        return $result;
    }

    public function find($id){
        return PackageManagement::find($id);
    }

   public function getList(){
       $result = PackageManagement::pluck('type_name', 'id');

       return $result;
   }

    public function save($data){
        return PackageManagement::create($data);
    }

    public function update($id,$data){
        $result = PackageManagement::find($id);
        return $result->update($data);
    }

    public function delete($id){
        return PackageManagement::destroy($id);
    }

    public function upload($file){
        $imageName = $file->getClientOriginalName();
        $fileName = date('Y-m-d-h-i-s') . '-' . preg_replace('[ ]', '-', $imageName);

        $file->move(public_path() . PackageManagement::FILE_PATH, $fileName);
        $fileName=PackageManagement::FILE_PATH.$fileName;
        return $fileName;
    }

    public function getActivePackageManagement()
    {
       return PackageManagement::where('status',1)->get();
    }

}
