<?php
namespace Modules\PageModule\Entities;

use Illuminate\Database\Eloquent\Model;
use Spatie\Activitylog\LogOptions;
use Spatie\Activitylog\Traits\CausesActivity;
use Spatie\Activitylog\Traits\LogsActivity;
use Spatie\Sluggable\HasSlug;
use Spatie\Sluggable\SlugOptions;

class PageModule extends Model
{
    use LogsActivity, CausesActivity, HasSlug;

    const FILE_PATH = '/uploads/pageModule/';

    protected $fillable = [
        'title',
        'slug',
        'sub_title',
        'page_placement',
        'meta_title',
        'meta_description',
        'meta_keyword',
        'description',
        'short_description',
        'image',
        'sort_order',
        'created_by',
        'updated_by',
        'status',
    ];

    /**
     * Configure the activity log options.
     */
    public function getActivitylogOptions(): LogOptions
    {
        return LogOptions::defaults()
            ->useLogName('PageModule')
            ->logOnly(['title', 'slug', 'status', 'created_by', 'updated_by'])
            ->setDescriptionForEvent(fn(string $eventName) => "PageModule has been {$eventName}");
    }

    public function getSlugOptions(): SlugOptions
    {
        return SlugOptions::create()
            ->generateSlugsFrom('title')
            ->saveSlugsTo('slug');
    }
}
