@extends('layouts.backmaster')

@section('title', 'ContactPerson')

@section('csssec')
@stop

@section('jssec')
@stop

@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
           Page Module
        </th>
        <th class="float-right">
            <a href="{{route('pagemodule.index')}}" class="btn btn-outline-primary pull-right">
                List</a>
        </th>
    </tr>
</table>
@endsection

@section('seccontent')
@if (session('status'))
<div class="alert alert-success">
    {{ session('status') }}
</div>
@endif

<div class="row">
    <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
        <div class="panel panel-default">
            <div class="panel-body">
                @if(!isset($pagemodule->id))
                <form method="post" action="{{route('pagemodule.store')}}" enctype="multipart/form-data" class="valid_form">
                    <input type="hidden" class="form-control" name="created_by" value="{{Auth::user()->id}}">

                    @else
                    <form method="post" action="{{route('pagemodule.update',$pagemodule)}}" method="post"
                        enctype="multipart/form-data" class="valid_form">
                        {{-- <input type="hidden" name="_method" value="put"> --}}
                        {{method_field('PUT')}}

                        <input type="hidden" class="form-control" name="updated_by" value="{{Auth::user()->id}}">
                        {{-- <input type="hidden" class="form-control" name="created_by" value="{{$pagemodule->created_by}}">
                        --}}
                        @endif
                        {{csrf_field()}}

                        <div class="row">
                            <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="title">Title:</label>
                                    <input type="text" name="title" class="form-control"
                                        value="{{old('title',$pagemodule->title)}}" required>
                                    @if ($errors->has('title'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('title') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="sub_title">Sub Title:</label>
                                    <input type="text" name="sub_title" class="form-control"
                                        value="{{old('sub_title',$pagemodule->sub_title)}}" required>
                                    @if ($errors->has('sub_title'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('sub_title') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                            <div class="col-md-4 col-xs-12">
                                <div class="form-group ">
                                    <label for="page_placement">Page Placement:</label>
                                    <select name="page_placement" class="myselect form-control">
                                        <option value=""></option>
                                        <option value="footera"{{$pagemodule->page_placement=='footera'?'selected':''}}>footera</option>
                                        <option value="footerb" {{$pagemodule->page_placement=='footerb'?'selected':''}}>footerb</option>
                                        <option value="footerc" {{$pagemodule->page_placement=='footerc'?'selected':''}}>footerc</option>
                                        <option value="nav" {{$pagemodule->page_placement=='nav'?'selected':''}}>nav</option>
                                    </select>

                                    @if ($errors->has('page_placement'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('page_placement') }}</strong>
                                    </span>
                                    @endif
                                </div>
                            </div>
                        </div>

                        <div class="row">

                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Image :</label>
                                    <input type="file" class="form-control dropify" name="image" value=""
                                        data-default-file="{{ ($pagemodule->image) ? asset($pagemodule->image) : '' }}">
                                    {{-- @if(isset($pagemodule->id))
                                        <img src="{{asset('/pressReleaseImage/'.$pagemodule->image)}}" height="100" width="150">
                                    @endif --}}
                                </div>
                            </div>

                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Short Description</label>
                                    <textarea type="text" name="short_description" class="form-control"
                                        required>{{old('short_description',$pagemodule->short_description)}}</textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-12 col-xs-12">
                                <div class="form-group">
                                    <label>Description</label>
                                    <textarea type="text" name="description" class="form-control my-editor"
                                        required>{{old('description',$pagemodule->description)}}</textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Meta Title</label>
                                    <textarea type="text" name="meta_title" class="form-control"
                                              required>{{old('meta_title',$pagemodule->meta_title)}}</textarea>
                                </div>
                            </div>
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label>Meta Desctiption</label>
                                    <textarea type="text" name="meta_description" class="form-control"
                                              required>{{old('meta_description',$pagemodule->meta_description)}}</textarea>
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6 col-xs-12">
                                <div class="form-group">
                                    <label for="status">Status:</label><br>
                                    <input type="radio" name="status" id="status" value="1" checked> Active<br>
                                    <input type="radio" name="status" id="status" value="0" {{$pagemodule->status=='0'?'checked':''}}> Inactive
                                </div>
                            </div>
                        </div>

                        <div class="row" style="padding:10px">
                            <div class="col-md-12">
                                <button class="btn btn-outline-warning float-right">Save</button>
                            </div>
                        </div>
                    </form>
            </div>
        </div>
    </div>
</div>

@endsection
