@extends('layouts.backmaster')

@section('title', 'PressRelease')

@section('csssec')
@stop

@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
        Pages Module
            {{-- <a href="{{route('contactperson.inactiveindex')}}" class="btn btn-info">Inactive Doctors</a>
            <a href="{{route('contactperson.index')}}" class="btn btn-info">Active Doctors</a> --}}
        </th>
        <th class="float-right">
            <a href="{{route('pagemodule.create')}}" class="btn btn-outline-primary float-right">Add New</a>
        </th>
    </tr>
</table>
@endsection
@section('seccontent')
<div class="row">
    <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
        <div class="panel panel-default">
            <div class="panel-body">
                @if(Session::has('success'))
                <div class="alert alert-success">
                    {{ Session::get('success') }}
                </div>
                @endif
                @if(Session::has('error'))
                <div class="alert alert-danger">
                    {{ Session::get('error') }}
                </div>
                @endif
                {{-- <form method="post" method="post" enctype="multipart/form-data" id="myForm"> --}}

                <table class="table table-bordered" id="datatable">
                    <thead>
                        <tr>
                            <th>S.N.</th>
                            <th>Title</th>
                            <th>Placement</th>
                            <th>Image</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($pagemodules as $i=>$eachcontactperson)
                        <tr id="{{$eachcontactperson->id}}">
                            {{-- </form> --}}
                            <td>{{$i+1}}</td>
                            <td>{{$eachcontactperson->title}}</td>
                            <td>{{$eachcontactperson->page_placement}}</td>
                            <td>
                                @if ($eachcontactperson->image!=null)
                                <img src="{{asset($eachcontactperson->image)}}" height="100" width="150">
                                @else
                                <h3>No Image </h3>
                                @endif
                            </td>

                            <td>
                                @if($eachcontactperson->status==1)
                                <label class="badge badge-success">Active</label>
                                @else
                                <label class="badge badge-danger">Inactive</label>
                                @endif
                            </td>

                            <td>
                                <a href="{{route('pagemodule.edit', $eachcontactperson)}}" class="btn btn-outline-warning"
                                    data-toggle="tooltip" title="Edit Info"><i class="fa fa-edit"> </i></a>
                                {{-- <a href="{{route('contactperson.show', $eachcontactperson->id)}}" data-toggle="tooltip"
                                    title="View Detail" class="btn btn-outline-warning"><i class="fa fa-eye"></i></a> --}}
{{--                                <a data-toggle="modal" data-target="#modal_project_delete" href='javascript:;' class="btn btn-outline-danger delete_information" link="{{route('categorymodule.delete',$eachcategorymodule->id)}}"><i class="fa fa-trash"></i></a>--}}

                                <form action="{{route('pagemodule.destroy', $eachcontactperson->id)}}" method="POST"
                                     style="display: inline;" id="delete_page_module_data">
                                    <input type="hidden" name="_method" value="delete">
                                    {{csrf_field()}}
                                    <a data-toggle="modal" data-target="#modal_project_delete_post" class="btn btn-outline-danger delete_information_post"  href='javascript:;' link="delete_page_module_data"><i class="fa fa-trash"></i></a>
                                </form>

                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
