@extends('layouts.backmaster')

@section('title', 'Sarathi Holidays')

@section('csssec')
@stop

@section('jssec')
@stop

@section('content_title')
    <table style="width:100%">
        <tr>
            <th class="headtext">
                Testimonial
            </th>
            <th class="float-right">
                <a href="{{ route('testimonial.index') }}" class="btn btn-outline-primary pull-right">
                    List</a>
            </th>
        </tr>
    </table>
@endsection

@section('seccontent')
    @if (session('status'))
        <div class="alert alert-success">
            {{ session('status') }}
        </div>
    @endif

    <div class="row">
        <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
            <div class="panel panel-default">
                <div class="panel-body">
                    @if (!isset($testimonial->id))
                        <form method="post" action="{{ route('testimonial.store') }}" enctype="multipart/form-data"
                            class="valid_form">
                            <input type="hidden" class="form-control" name="created_by" value="{{ Auth::user()->id }}">
                        @else
                            <form method="post" action="{{ route('testimonial.update', $testimonial) }}" method="post"
                                enctype="multipart/form-data" class="valid_form">
                                {{-- <input type="hidden" name="_method" value="put"> --}}
                                {{ method_field('PUT') }}

                                <input type="hidden" class="form-control" name="updated_by" value="{{ Auth::user()->id }}">
                                {{-- <input type="hidden" class="form-control" name="created_by" value="{{$testimonial->created_by}}">
                        --}}
                    @endif
                    {{ csrf_field() }}

                    <div class="row">
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group ">
                                <label for="name">Name:</label>
                                <input type="text" name="name" class="form-control"
                                    value="{{ old('name', $testimonial->name) }}" required>
                                @if ($errors->has('name'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('name') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group ">
                                <label for="rating">Rating:</label>
                                <input type="text" name="rating" class="form-control"
                                    value="{{ old('rating', $testimonial->rating) }}" required>
                                @if ($errors->has('rating'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('rating') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>






                    </div>




                    <div class="row">


                        <div class="col-md-6 col-xs-12">
                            <div class="form-group ">
                                <label for="sort_order"> Sort Order:</label>
                                <input type="number" name="sort_order" class="form-control"
                                    value="{{ old('sort_order', $testimonial->sort_order) }}" required>
                                @if ($errors->has('sort_order'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('sort_order') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group ">
                                <label for="message"> Message:</label>
                                <input type="text" name="message" class="form-control"
                                    value="{{ old('message', $testimonial->message) }}" required>
                                @if ($errors->has('message'))
                                    <span class="help-block">
                                        <strong>{{ $errors->first('message') }}</strong>
                                    </span>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group">
                                <label>Image :</label>
                                <input type="file" class="form-control dropify" name="image" value=""
                                    data-default-file="{{ $testimonial->image ? asset($testimonial->image) : '' }}">
                                @if (isset($testimonial->id))
                                    <img src="{{ asset($testimonial->image) }}" height="100" width="150">
                                @endif
                            </div>
                        </div>
                    </div>


                    <div class="row">
                        <div class="col-md-6 col-xs-12">
                            <div class="form-group">
                                <label for="status">Status:</label><br>
                                <input type="radio" name="status" id="status" value="1" checked> Active<br>
                                <input type="radio" name="status" id="status" value="0"
                                    {{ $testimonial->status == '0' ? 'checked' : '' }}> Inactive
                            </div>
                        </div>
                    </div>

                    <div class="row" style="padding:10px">
                        <div class="col-md-12">
                            <button class="btn btn-outline-success float-right">Save</button>
                        </div>
                    </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@endsection
