@extends('layouts.backmaster')

@section('title', 'PressRelease')

@section('csssec')
@stop

@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
        Testimonial
            {{-- <a href="{{route('testimonial.inactiveindex')}}" class="btn btn-outline-info">Inactive Doctors</a>
            <a href="{{route('testimonial.index')}}" class="btn btn-outline-info">Active Doctors</a> --}}
        </th>
        <th class="float-right">
            <a href="{{route('testimonial.create')}}" class="btn btn-outline-primary float-right">Add New</a>
        </th>
    </tr>
</table>
@endsection
@section('seccontent')
<div class="row">
    <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
        <div class="panel panel-default">
            <div class="panel-body">
                @if(Session::has('success'))
                <div class="alert alert-success">
                    {{ Session::get('success') }}
                </div>
                @endif
                @if(Session::has('error'))
                <div class="alert alert-danger">
                    {{ Session::get('error') }}
                </div>
                @endif
                {{-- <form method="post" method="post" enctype="multipart/form-data" id="myForm"> --}}

                <table class="table table-bordered" id="datatable">
                    <thead>
                        <tr>
                            <th>S.N.</th>
                            <th>Name</th>
                            <th>Rating</th>
                            <th>Sort Order</th>
                            <th>Status</th>
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($testimonials as $i=>$eachtestimonial)
                        <tr id="{{$eachtestimonial->id}}">
                            {{-- </form> --}}
                            <td>{{$i+1}}</td>
                            <td>{{$eachtestimonial->name}}</td>
                            <td>{{$eachtestimonial->rating}}</td>


                                <td>
                                    {{$eachtestimonial->sort_order}}
                                </td>



                            <td>
                                @if($eachtestimonial->status==1)
                                <label class="badge badge-success">Active</label>
                                @else
                                <label class="badge badge-danger">Inactive</label>
                                @endif
                            </td>

                            <td>
                                <a href="{{route('testimonial.edit', $eachtestimonial)}}" class="btn btn-outline-warning"
                                    data-toggle="tooltip" title="Edit Info"><i class="fa fa-edit"> </i></a>
                                <a href="{{route('testimonial.show', $eachtestimonial->id)}}" data-toggle="tooltip"
                                    title="View Detail" class="btn btn-outline-success"><i class="fa fa-eye"></i></a>
                                <form action="{{route('testimonial.destroy', $eachtestimonial->id)}}" method="POST"
                                    onsubmit="return confirm('Are You Sure??')" style="display: inline;" id="delete-information-form">
                                    <input type="hidden" name="_method" value="delete">
                                    {{csrf_field()}}
                                    <button type="submit" class="btn btn-outline-danger" data-toggle="tooltip"
                                        title="Delete Information"><i class="fa fa-trash"></i></button>

                                </form>

                            </td>
                        </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>
@endsection
