<?php

namespace Modules\UserManagement\Http\Controllers;



use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Http\Response;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\RedirectResponse;
use Laravel\Socialite\Facades\Socialite;

use Illuminate\Support\Facades\Session;
use Modules\AclManagement\Models\Role;
use Illuminate\Contracts\Support\Renderable;
use Modules\UserProfile\Models\UserProfile;
use Modules\BranchModule\Models\BranchModule;

class UserController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */


    public function index()
    {
        $user=User::all();
        $role=Role::all();
        return view('usermanagement::user.index',compact('user','role'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $role=Role::all();

        return view('usermanagement::user.create',compact('role'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $data=$request->all();

        $request->validate(
            [
            'role_id' => ['required'],
            'name' => ['required', 'string', 'max:255'],
            // 'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);

        if ($request->is_employee) {
            $userprofile_id=auth()->user()->userprofile->id;
            $associated_to=auth()->user()->id;
        }
        else{
            $userprofile_id=null;
            $associated_to=null;
        }
        $user=User::create([
            'name'=>$request->input('name'),
            'email'=>$request->input('email'),
            'is_admin'=>$request->is_admin,
            'is_employee'=>$request->is_employee,
            'userprofile_id'=>$userprofile_id,
            'associated_to'=>$associated_to,
            'password'=>bcrypt($request->input('password')),
        ]);
        $finalstatus=$user->roles()->attach($request->input('role_id'));
        $admins = User::all();
        if ($user) {
            try {
                if ($request->is_employee==null) {
                    $data['user_id']=$user->id;
                    UserProfile::create($data);
                }
                // Notification::send($admins, new UserRegistered($status));
            } catch(\Exception $e){

            }
            Session::flash('success', 'Information Added successfully.');
        } else {
            Session::flash('error', 'Information Cannot be Added');
        }
        return redirect()->route('user.index');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $user=User::find($id);
        $role =Role::all();

        $aru = [];
        $rolename = [];
        $loggeduser=Auth::user();
        foreach($loggeduser->roles as $ru){
            array_push($rolename,$ru->name);
        }
        foreach($user->roles as $ru){
            array_push($aru,$ru->id);
        }
        // dd($rolename);
        return view('usermanagement::user.edit',compact('user','aru','role','rolename'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $user=User::find($id);
        $request->validate(
            [

            'name' => ['required', 'string', 'max:255'],
            'email' => 'required|email|unique:users,email,'.$user->id,
            // 'email' => ['required', 'string', 'email', 'max:255', 'unique:users,email,'.$id],
            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);


        $user->name=$request->input('name');
        $user->is_admin=$request->is_admin;

        if($request->password!=null || $request->password!="")
        {
        $user->password=bcrypt($request->input('password'));
        }

        $status=$user->update();

//        $user->update()->roles()->sync($request->input('role_id[]'));
        $user->roles()->sync( $request->input('role_id') );
        if ($status) {
            Session::flash('success', 'Information Updated successfully.');
        } else {
            Session::flash('error', 'Information Cannot be Update');
        }
        return redirect()->route('user.index');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $user = User::find($id);
        $user->status = 0;
         $user->update();
        return redirect()->route('user.index');
    }

    public function assign($id)
    {
        $role = Role::all();
        $user=User::find($id);
        return view('usermanagement::user.create',compact('role','user'));
    }


    public function assign_role(Request $request ,$id)
    {
        $user=User::find($id);
        $user->roles()->attach($request->input('role_id'));
        return redirect()->route('user.index');
    }

    public function  edit_role(Request $request,$id)
    {
        $user=User::find($id);
        $user->roles()->sync($request->input('role_id'));
        return redirect()->route('user.index');
    }

    public function myedit($id = null)
    {
        // dd("SC");
        $user = Auth::guard('web')->user();
        // dd($user);
        // $role = Role::all(/);
        // $branch = Branch::all();

        // $aru = [];
        // foreach ($user->roles as $ru) {
        //     array_push($aru, $ru->id);
        // }
        // $br = [];
        // foreach ($user->branches as $ru) {
        //     array_push($br, $ru->id);
        // }

        return view('usermanagement::user.myedit', compact('user'));
    }

    public function myupdate(Request $request, $id)
    {
        $user = User::find($id);

        $request->validate(
            [

            // 'name' => ['required', 'string', 'max:255'],
            // 'email' => ['required', 'string', 'email', 'max:255', 'unique:users,email,'.$id],
            'email' => 'required|email|unique:users,email,'.$user->id,

            'password' => ['required', 'string', 'min:8', 'confirmed'],
        ]);
        // dd($request);
        $user->name=$request->input('name');
        // $user->email=$request->input('email');
        $user->password = bcrypt($request->input('password'));
        // dd($user);
        $user->update();
        // $user->roles()->sync( $request->input('role_id') );
        return redirect('home');
    }
    public function changestatus($id)
    {
        $user = User::find($id);
        // dd($user);

        if ($user->status == 0) {
            $user->status = 1;
        } else {
            $user->status = 0;
        }

        $status = $user->update();
        return redirect()->route('user.index');

    }
    public function verifyuserstatus($id)
    {
        $user = User::find($id);
        // dd($user);
        $date=date('Y-m-d H:i:s');

        $user->email_verified_at = $date;
        $status = $user->update();
        return redirect()->route('user.index');

    }


    // socialite use

public function redirect($provider)
{
    return Socialite::driver($provider)->redirect();
}


public function Callback($provider)
{

    $userSocial = Socialite::driver($provider)->stateless()->user();
    // $userSocial = Socialite::driver($provider)->user();

    $users = User::where(['email' => $userSocial->getEmail()])->first();
    if ($users) {
        Auth::login($users);
        return redirect('/home');
    } else {
        $users = User::create([
            'name' => $userSocial->getName(),
            'email' => $userSocial->getEmail(),
            'provider_id' => $userSocial->getId(),
            'provider' => $provider,
            'avatar' => $userSocial->getAvatar(),

        ]);
        Auth::login($users);
        return redirect('/home');
    }
}


// socialite use

public function myprofile($id)
{
    $data['user'] = User::find($id);
    // dd($data);
    return view('usermanagement::user.myprofile',$data);
}

public function userprofile($id)
{
    $data['user'] = User::find($id);
    // dd($data);
    return view('usermanagement::user.userprofile',$data);
}

}
