@extends('layouts.master')

@section('title', 'User Profile')

@section('csssec')
@stop

@section('jssec')
@stop

@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
            User Profile
        </th>
        <th class="float-right">
            <a href="{{route('user.index')}}" class="btn uniform_use_button float-right">Information
                List</a>
        </th>
    </tr>
</table>
@endsection

@section('content')

@if (session('status'))
<div class="alert alert-success">
    {{ session('status') }}
</div>
@endif


<div class="row">
    <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
        <div class="panel panel-default">
            <div class="panel-body">
                <form action="{{route('user.store')}}" method="post" enctype="multipart/form-data" class="valid_form">
                    {{csrf_field()}}
                    <div class="form-group ">
                        <label for="name">Name</label>
                        <input class="form-control" type="text" name="name" id="name" required>
                        @if ($errors->has('name'))
                        <span class="help-block">
                            <strong>{{ $errors->first('name') }}</strong>
                        </span>
                        @endif
                    </div>
                    <div class="form-group ">
                        <label for="email">Email</label>
                        <input class="form-control" type="email" name="email" id="email" required>
                        @if ($errors->has('email'))
                        <span class="help-block">
                            <strong>{{ $errors->first('email') }}</strong>
                        </span>
                        @endif
                    </div>
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" name="password" id="password" class="form-control" required>
                        @if ($errors->has('password'))
                        <span class="help-block">
                            <strong>{{ $errors->first('password') }}</strong>
                        </span>
                        @endif
                    </div>
                    <div class="form-group">
                        <label for="password-confirm">Confirm Password</label>

                        <input id="password-confirm" type="password" class="form-control" name="password_confirmation"
                            required>
                    </div>
                    <div class="form-group">
                        <label> Select Role:</label>
                        <br>
                        @foreach($role as $r)
                            <input type="checkbox" name="role_id[]" value="{{$r->id}}"> {{ucfirst($r->name)}}<br>
                        @endforeach
                    </div>
                    <div class="form-group">
                        <strong> Backend Admin:</strong>
                        <br>
                        <input type="checkbox" name="is_admin" value="1">
                        <label> Is Admin</label>
                    </div>
                    <div class="form-group">
                        <strong> Associated To My bussiness:</strong>
                        <br>
                        <input type="checkbox" name="is_employee" value="1">

                        <label> Is My Employee</label>

                    </div>
                    <input type="submit" name="submit" value="Save" class="btn uniform_use_button float-right">
                </form>
            </div>
        </div>
    </div>
</div>

            @endsection
