@extends('layouts.master')

@section('seccontent')
    <!-- breadcrumb start -->
    <div class="referal_title">
        <div class="page_name">

            User
        </div>


        <nav aria-label="breadcrumb" class="breadcrumb">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="#">Home</a></li>

                <li class="breadcrumb-item active" aria-current="page">User</li>
            </ol>
        </nav>

    </div>
    <!-- breadcrumb start -->

    <div class="below_breadcrumb_devide">
        <a href="{{ route('user.index') }}">

            <div class="add_new">

                <img src="{{ asset('newpanel/icons/goback-btn.png') }}" alt="">
                <p> List </p>
            </div>
        </a>

    </div>

    <!--------------------------------------- Add New table_section_start --------------------------->

    <div class="add_new_cake">

        <form role="form" action="{{route('user.update',$user->id)}}" method="post" class="valid_form"
            enctype="multipart/form-data">
            {{csrf_field()}}
            <input type="hidden" name="_method" value="PUT">

        <div class="col-xl-8 mx-auto">

            <div class="row">

                <div class="mb-5 col-xl-12 col-md-12">
                    <label for="Name" class="form-label">Name:</label>
                    <input type="text" name="name" class="form-control" value="{{$user->name}}"
                        required>
                    @if ($errors->has('name'))
                        <span class="help-block">
                            <strong>{{ $errors->first('name') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="mb-5 col-xl-12 col-md-12">
                    <label for="Email" class="form-label">Email:</label>
                    <input type="text" name="email" class="form-control" value="{{$user->email}}"
                        required>
                    @if ($errors->has('email'))
                        <span class="help-block">
                            <strong>{{ $errors->first('email') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="mb-5 col-xl-12 col-md-12">
                    <label for="Password" class="form-label">Password:</label>
                    <input type="password" name="password" class="form-control" id="password"
                        required>
                    @if ($errors->has('password'))
                        <span class="help-block">
                            <strong>{{ $errors->first('password') }}</strong>
                        </span>
                    @endif
                </div>
                <div class="mb-5 col-xl-12 col-md-12">
                    <label for="password-confirm" class="form-label">Confirm Password:</label>
                    <input id="password-confirm" type="password" class="form-control" name="password_confirmation"
                            required>
                    @if ($errors->has('password'))
                        <span class="help-block">
                            <strong>{{ $errors->first('password') }}</strong>
                        </span>
                    @endif
                </div>
                @if (in_array('superadmin',$rolename))
                <div class="mb-5 col-xl-12 col-md-12">
                    <label> Roles:</label>
                    <br>
                    @foreach($role as $r)
                    @if(in_array($r->id,$aru))
                        <input type="checkbox" name="role_id[]" value="{{$r->id}}" checked> {{ucfirst($r->name)}}<br>
                    @else
                        <input type="checkbox" name="role_id[]" value="{{$r->id}}"> {{ucfirst($r->name)}}<br>
                    @endif
                    @endforeach
                </div>
                @endif

                <div class="mb-5 col-xl-12 col-md-12">
                    <strong> Backend Admin:</strong>
                        <br>
                        <input type="checkbox" name="is_admin" value="1" {{$user->is_admin?'checked':''}}>
                        <label> Is Admin</label>
                </div>
                <div class="mb-5 col-xl-12 col-md-12">
                    <strong> Associated To My bussiness:</strong>
                        <br>
                        <input type="checkbox" name="is_employee" value="1" {{$user->is_employee?'checked':''}}>

                        <label> Is My Employee</label>

                </div>



            <div class="save">
                <button type="submit" class="btn save_item">
                    Update
                </button>
                {{-- <input type="submit" name="submit" value="Save Item" class="btn save_item uniform_use_button float-right"> --}}

            </div>
        </div>
        </form>
    </div>

    <!---------------------------------------Add New table_section_start --------------------------->
@endsection
