@extends('layouts.master')
@section('content_title')
<table style="width:100%">
    <tr>
        <th class="headtext">
            User Profile
        </th>
        <th class=" float-right">
            <a href="{{route('user.index')}}" class="btn uniform_use_button float-right">Information
                List</a>
        </th>
    </tr>
</table>
@endsection
@section('content')
@if (session('status'))
<div class="alert alert-success">
    {{ session('status') }}
</div>
@endif

{{-- @if ($errors->any())
    <div class="alert alert-danger">
        <ul style="list-style-type: none;">
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif --}}

<div class="row">
    <div class="col-md-12 col-lg-12 col-xl-12 col-sm-12 col-xs-12">
        <div class="panel panel-default">
            <div class="panel-body">

                <form role="form" action="{{route('user.update',$user->id)}}" method="post" class="valid_form"
                    enctype="multipart/form-data">
                    {{csrf_field()}}
                    <input type="hidden" name="_method" value="PUT">

                    <div class="form-group">
                        <label for="name"> Name</label>
                        <input type="text" class="form-control" id="name" name="name" value="{{$user->name}}">
                    </div>
                    <div class="form-group">
                        <label for="email">Email</label>
                        <input type="email" class="form-control" id="email" name="email" value="{{$user->email}}">

                        {{-- <p>{{$user->email}}</p> --}}
                    </div>
                    <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" name="password" id="password" class="form-control" >
                        @if ($errors->has('password'))
                        <span class="help-block">
                            <strong style="color:red;">{{ $errors->first('password') }}</strong>
                        </span>
                        @endif
                    </div>
                    <div class="form-group">
                        <label for="password-confirm">Confirm Password</label>

                        <input id="password-confirm" type="password" class="form-control" name="password_confirmation"
                            >
                    </div>
                    {{-- <div class="form-group">
                        <label for="password">Password</label>
                        <input type="password" class="form-control" id="password" name="password" value="">
                    </div> --}}

                    @if (in_array('superadmin',$rolename))
                    <div class="form-group">
                        <label> Roles:</label>
                        <br>
                        @foreach($role as $r)
                        @if(in_array($r->id,$aru))
                            <input type="checkbox" name="role_id[]" value="{{$r->id}}" checked> {{ucfirst($r->name)}}<br>
                        @else
                            <input type="checkbox" name="role_id[]" value="{{$r->id}}"> {{ucfirst($r->name)}}<br>
                        @endif
                        @endforeach
                    </div>
                    @endif
                    <div class="form-group">
                        <strong> Backend Admin:</strong>
                        <br>
                        <input type="checkbox" name="is_admin" value="1" {{$user->is_admin?'checked':''}}>
                        <label> Is Admin</label>
                    </div>
                    <div class="form-group">
                        <strong> Associated To My bussiness:</strong>
                        <br>
                        <input type="checkbox" name="is_employee" value="1" {{$user->is_employee?'checked':''}}>

                        <label> Is My Employee</label>

                    </div>

                    <div class="box-footer">
                        <button type="submit" class="btn uniform_use_button">Submit</button>
                    </div>
            </div>
            </form>
        </div>
    </div>
</div>

            @endsection
