<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;

return new class extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('userprofiles', function (Blueprint $table) {
            $table->id();
            $table->string("company_name")->nullable();
            $table->string("name")->nullable();
            $table->string("t_address")->nullable();
            $table->string("p_address")->nullable();
            $table->string("mobile")->nullable();
            $table->string("image")->nullable();
            $table->string("fb")->nullable();
            $table->string("twitter")->nullable();
            $table->string("linkedin")->nullable();
            $table->string("youtube")->nullable();
            $table->string("instagram")->nullable();
            $table->string("whatsapp")->nullable();
            $table->string("gmail")->nullable();
            $table->string("email")->nullable();
            $table->string("contact")->nullable();
            // $table->string("mobile")->nullable();
            $table->string("tiktok")->nullable();
            $table->integer("status")->default(1);
            $table->text("short_description")->nullable();
            $table->longText("description")->nullable();
            $table->bigInteger("user_id")->unsigned()->nullable();
            $table->bigInteger("created_by")->unsigned()->nullable();
            $table->bigInteger("updated_by")->unsigned()->nullable();

            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('userprofiles');
    }
};
