<?php

namespace App\Handlers;

use Exception;
use Throwable;
use App\Models\LogMessage;
use Illuminate\Support\Facades\Log;
use Monolog\Handler\AbstractProcessingHandler;
// use Yoeriboven\LaravelLogDb\Models\LogMessage;

class DatabaseHandler extends AbstractProcessingHandler
{
    /**
     * @inheritDoc
     */
    protected function write($record): void
    {

        $record = is_array($record) ? $record : $record->toArray();
        $exception = $record['context']['exception'] ?? null;

        if ($exception instanceof Throwable) {
            $record['context']['exception'] = (string) $exception;
        }
        // dd($record,$r1);


        try {

            $x=LogMessage::create([
                'level' => $record['level'],
                'level_name' => $record['level_name'],
                'message' => $record['message'],
                'logged_at' => $record['datetime'],
                'context' => $record['context'],
                'extra' => $record['extra'],
                'user_id' => auth()->check()?auth()->user()->id:null,
                'customer_id' => auth()->guard('generaluser')->check()?auth()->guard('generaluser')->user()->id:null,
            ]);

        } catch (Exception $e) {
            $fallbackChannels = config('logging.channels.fallback.channels', ['daily']);
            // dd($record['message']);
            // dd($e->getMessage());
            // Log::error($e->getMessage(), ['stack_trace' => $e->getTraceAsString()]);
            Log::stack($fallbackChannels)->debug($record['message']);

            Log::stack($fallbackChannels)->debug('Could not log to the database.', [
                'exception' => $e,
            ]);
        }

    }
}
