<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Auth\Middleware\EnsureEmailIsVerified;

// class EnduserEmailIsVerified
// {
//     // public function handle($request, Closure $next)
//     // {
//     //     return $next($request);
//     // }
//     public function handle($request, Closure $next, $redirectToRoute = null, $guard = null)
//     {
//         if (! $request->user($guard) ||
//             ($request->user($guard) instanceof MustVerifyEmail &&
//             ! $request->user($guard)->hasVerifiedEmail())) {
//             return $request->expectsJson()
//                     ? abort(403, 'Your email address is not verified.')
//                     : Redirect::route($redirectToRoute ?: 'verification.notice');
//         }

//         return $next($request);
//     }

// }
class GeneralEmailIsVerified extends EnsureEmailIsVerified
{
    public function handle($request, Closure $next,$guard=null)
    {

        // if ($guard == 'enduser') {
            $guard='generaluser';


            if (Auth::guard('generaluser')->check()) {

                if (! Auth::guard($guard)->user()->hasVerifiedEmail()) {
                    Session::flash('success', 'You need to verify first to move further');

                    return $request->expectsJson()
                            ? abort(403, 'Your email address is not verified.')
                            : Redirect::route('generaluser_verification.notice');
                }


            }

        // return parent::handle($request, $next);
        return $next($request);

    }
}
