<?php

namespace App\Livewire\Main;

use Livewire\Component;
use Livewire\WithPagination;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Session;
use Modules\AclManagement\Models\Module;

class ModuleList extends Component
{
    use WithPagination;
    protected $paginationTheme = 'bootstrap';
    public $module_id,$name,$status,$url,$parent,$show_to_admin,$id;
    public $searchTerm = '';

    public function updated($fields){
        $this->validateOnly($fields,[
            "name"=>'required',
            "url"=>'required',
        ]);

    }



    public function openmodal()
    {
        $this->dispatch('add-new-modal');
        $this->emptySelected();


    }



    public function emptySelected() //after update complete this will be called
    {
        $datatest = Module::select('id as id', 'name as text')->where('parent',null)->latest()->get();
        $this->dispatch('empty-selected', datatest: collect($datatest)); // can i ? yes, wher e is
    }

    public function selectSelected() //edit button clicked this will call
    {
        $datatest = Module::select('id as id', 'name as text')->where('parent',null)->latest()->get();
        //we are getting correct data at console
        $this->dispatch('select-selected', datatest: collect($datatest), get_id: $this->parent); // can i ? yes
    }

    public function addSelect()
    {
        // dd($this->parent);
        $this->validate([
            "name"=>'required',
            "url"=>'required',
        ]);

        $x=Module::create([
            // "parent"=>$this->parent,
            'parent' => empty($this->parent)?null:$this->parent,
            "name"=>$this->name,
            "url"=>$this->url,
            "status"=>$this->status,
            "show_to_admin"=>$this->show_to_admin,
        ]);
        Log::channel('db')->info("Module Created",[
            "name"=>$this->name,
            "url"=>$this->url,
        ]);
        // dd($x);
        $this->dispatch('toast-message', message: "Information is stored successfully",type:"success");


        // toast('Information stored successfully','success');

        $this->resetInputs();
        $this->dispatch("close-modal");

        $this->emptySelected();

    }

    public function resetInputs(){
        $this->module_id='';
        $this->parent='';
        $this->name='';
        $this->url='';
        $this->satus='';
        $this->show_to_admin='';

    }

    public function edit($id){
        $moduledata=Module::where('id',$id)->first();
        $this->module_id=$moduledata->id;
        $this->parent=$moduledata->parent;
        $this->name=$moduledata->name;
        $this->url=$moduledata->url;
        $this->status=$moduledata->status;
        $this->show_to_admin=$moduledata->show_to_admin;
        $this->selectSelected(); //only this is need here


        $this->dispatch("show-edit-modal");


    }

    public function editData(){

        $this->validate([
            "name"=>'required',
            "url"=>'required',
        ]);
        $data=Module::where('id',$this->module_id)->first();
        $data->parent=empty($this->parent)?null:$this->parent;
        $data->name=$this->name;
        $data->url=$this->url;
        $data->status=$this->status;
        $data->show_to_admin=$this->show_to_admin;
        $data->save();

        Log::channel('db')->info("Fiscal Year updated of id=".$this->module_id,[
            "name"=>$this->name,
            "url"=>$this->url]);
            // $this->emptySelected(); //only this here
        $this->resetInputs();

        // Session::flash("success","Module is edited successfully");
        $this->dispatch('toast-message', message: "Information is edited successfully",type:"success");



        $this->dispatch("close-modal");

    }

    public function deleteConfirmation($id){
        $this->module_id=$id;
        $this->dispatch('show-delete-confirmation-modal');


    }
    public function deleteModuleData(){
          $data=Module::where('id',$this->module_id)->first();
          $selected_modules=$data;
          Log::channel('db')->info("Module Deleted of id=".$this->module_id,$data->toArray());
          $selected_modules->roles()->detach();


           $deleted=$data->delete();
           if ($deleted) {
            Module::where('parent',$this->module_id)->delete();

           }
          $this->resetInputs();
          $this->dispatch('toast-message', message: "Information is deleted successfully",type:"success");

        //   toast('Information deleted successfully','success');
        //   Session::flash("success","User Position is deleted successfully");

          $this->dispatch("close-modal");
          $this->emptySelected();



    }
    public function cancel(){

        $this->resetInputs();

    }

    public function viewDetails($id)
    {
        $data = Module::find($id);
        $this->module_id = $data->id;
        $this->parent = $data->parent;
        $this->name = $data->name;
        $this->url = $data->url;
        $this->status = $data->status;
        $this->show_to_admin = $data->show_to_admin;
        $this->dispatch("show-view-modal");
    }

    public function closeViewModal()
    {
        $this->module_id = '';
        $this->parent = '';
        $this->name = '';
        $this->url = '';
        $this->status = '';
        $this->show_to_admin = '';

    }



    public function render()
    {
        $data['parents'] = Module::where('parent',null)->latest()->get();
        $modulesdata = Module::latest();

        if(!empty($this->searchTerm)){
            $modulesdata->orWhere('name','like',"%".$this->searchTerm."%");
       }
       $data['module_list'] = $modulesdata->paginate(50);
        return view('livewire.main.module-list',$data);
    }
}
