<?php

namespace App\Livewire;

use Livewire\Component;
use App\Models\LogMessage;
use Livewire\WithPagination;

class UserlogManagementCustomer extends Component
{
    use WithPagination;
    protected $paginationTheme = 'bootstrap';
    public $searchTerm = '';
    public $start_date = '';
    public $end_date = '';
    public $id = '';
    public $userId = '';
    public $log_data;


    public function mount($userId=null){
        $this->userId=$userId;


    }
    public function viewDetail($id){
        $this->log_data=LogMessage::find($id);
        // dd($this->log_data);
        $this->id=$id;
        $this->dispatch('show-view-modal');

    }

    public function render()
    {
        $fdata = LogMessage::where('customer_id',$this->userId)->where('level', 200)->latest();
        // $this->redirect(route('categorymodule.index'));

        if(!empty($this->searchTerm)){
            $fdata->orWhere('message','like',"%".$this->searchTerm."%");
       }
        if(!empty($this->end_date) && !empty($this->start_date)){
            // dd($this->start_date,);
            $fdata->whereBetween('created_at',[$this->start_date,$this->end_date]);
       }
       $data['logs'] = $fdata->paginate(20);

        // return view('livewire.userlog-management');
        if (auth()->check()) {
            return view('livewire.userlog-management',$data)->layout('layouts.livewire-master');
        }
        else{
            return view('livewire.userlog-management',$data)->layout('layouts.livewire-master');

        }

    }
}

