<?php

namespace App\Rules;

use Closure;
use Illuminate\Support\Facades\Http;
use Illuminate\Contracts\Validation\ValidationRule;

class ReCaptcha implements ValidationRule
{
    /**
     * Run the validation rule.
     *
     * @param  \Closure(string): \Illuminate\Translation\PotentiallyTranslatedString  $fail
     */
    public function validate(string $attribute, mixed $value, Closure $fail): void
    {
        // Skip validation in local/dev environment
        if (app()->environment('local')) {
            return;
        }

        $response = Http::asForm()->post("https://www.google.com/recaptcha/api/siteverify", [
            'secret'   => config('services.recaptcha.secret'), // use config instead of env()
            'response' => $value,
        ]);

        $result = $response->json();

        if (!($result['success'] ?? false)) {
            $fail('The Google reCAPTCHA validation failed.');
            return;
        }

        // For reCAPTCHA v3 → check score (adjust threshold as needed)
        if (($result['score'] ?? 0) < 0.5) {
            $fail('Suspicious activity detected. Please try again.');
        }
    }
}