<?php
namespace App\Traits;
use carbon\carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Request;
use Stevebauman\Location\Facades\Location;

trait ActivityTraits
{

  public function LogLocationDetail()
  {
      $updated_at = Carbon::now()->format('d/m/Y H:i:s');
      $ip= Request::ip();
      $data = Location::get($ip);



      if (auth()->guard('generaluser')->check()) {
          $user=auth()->guard('generaluser')->user();
        }
        else{
            $user=Auth::user();
      }

      $properties = [
          'attributes' =>['id'=>$user->id,'description'=>'Login into the system by '.$updated_at,'ip'=>$ip,'location'=>$data]
      ];

      return ['id'=>$user->id,'description'=>'Login into the system by '.$updated_at,'ip'=>$ip,'location'=>$data];
  }

  public function LogEnduserLocationDetail()
  {
      $updated_at = Carbon::now()->format('d/m/Y H:i:s');
      $ip= Request::ip();
    //   dd($ip);
      $data = Location::get($ip);
      $user=auth()->guard('enduser')->user();
      $properties = [
          'attributes' =>['id'=>$user->id,'description'=>'Login into the system by '.$updated_at,'ip'=>$ip,'location'=>$data]
      ];


      $changes = "End user Location track";

      $activity = activity()
      ->useLog("User Activity")
          ->causedBy($user)
          ->performedOn($user)
          ->withProperties($properties)
          ->log($changes);

      return true;
  }

  public function unsetAttributes($model){
      unset($model->created_at);
      unset($model->updated_at);
      return $model;
  }

}
