<?php

use App\Http\Middleware\IsAdmin;
use App\Http\Middleware\setLanguage;
use Illuminate\Foundation\Application;
use App\Http\Middleware\CheckPermission;
use App\Http\Middleware\DefaultPermission;
use App\Http\Middleware\AuthenticateCustom;
use App\Http\Middleware\GeneralEmailIsVerified;
use Illuminate\Foundation\Configuration\Exceptions;
use Illuminate\Foundation\Configuration\Middleware;

return Application::configure(basePath: dirname(__DIR__))
    // ->withRouting(
    //     web: __DIR__.'/../routes/web.php',
    //     commands: __DIR__.'/../routes/console.php',
        // channels: __DIR__.'/../routes/channels.php',
    //     health: '/up',
    //     then: function () {
    //         Route::namespace('Teacher')->prefix('teacher')->name('teacher.')->group(base_path('routes/teacher.php'));
    //     },
    // )
    ->withRouting(
        commands: __DIR__.'/../routes/console.php',
        channels: __DIR__.'/../routes/channels.php',
        using: function () {
            Route::middleware('api')
                ->prefix('api')
                ->group(base_path('routes/api.php'));

            Route::middleware('web')
                ->group(base_path('routes/web.php'));

            Route::middleware('web')
                ->group(base_path('routes/costume.php'));
        },
    )

    ->withMiddleware(function (Middleware $middleware) {
        $middleware->alias([
            'defaultpermission' =>  DefaultPermission::class,
            'checkpermission' => CheckPermission::class,
            'is_super_admin' => IsAdmin::class,
            'generaluser_mail_verified' => GeneralEmailIsVerified::class,
            'auth' => AuthenticateCustom::class,

        ]);
        $middleware->web([
            setLanguage::class,
        ]);
        //
    })
    ->withExceptions(function (Exceptions $exceptions) {
        //
    })->create();
